/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.ColumnsExtractor;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.table.distributed.IndexLocker;
import org.apache.ignite3.internal.tx.Lock;
import org.apache.ignite3.internal.tx.LockKey;
import org.apache.ignite3.internal.tx.LockManager;
import org.apache.ignite3.internal.tx.LockMode;

public class HashIndexLocker
implements IndexLocker {
    private final int indexId;
    private final LockMode modificationMode;
    private final LockManager lockManager;
    private final ColumnsExtractor indexRowResolver;

    public HashIndexLocker(int indexId, boolean unique, LockManager lockManager, ColumnsExtractor indexRowResolver) {
        this.indexId = indexId;
        this.modificationMode = unique ? LockMode.X : LockMode.IX;
        this.lockManager = lockManager;
        this.indexRowResolver = indexRowResolver;
    }

    @Override
    public int id() {
        return this.indexId;
    }

    @Override
    public CompletableFuture<Void> locksForLookupByKey(UUID txId, BinaryTuple key) {
        return this.lockManager.acquire(txId, new LockKey(this.indexId, key.byteBuffer()), LockMode.S).thenApply(lock -> null);
    }

    @Override
    public CompletableFuture<Void> locksForLookup(UUID txId, BinaryRow tableRow) {
        BinaryTuple key = this.indexRowResolver.extractColumns(tableRow);
        return this.locksForLookupByKey(txId, key);
    }

    @Override
    public CompletableFuture<Lock> locksForInsert(UUID txId, BinaryRow tableRow, RowId rowId) {
        BinaryTuple key = this.indexRowResolver.extractColumns(tableRow);
        return this.lockManager.acquire(txId, new LockKey(this.indexId, key.byteBuffer()), this.modificationMode).thenApply(lock -> null);
    }

    @Override
    public CompletableFuture<Void> locksForRemove(UUID txId, BinaryRow tableRow, RowId rowId) {
        BinaryTuple key = this.indexRowResolver.extractColumns(tableRow);
        return this.lockManager.acquire(txId, new LockKey(this.indexId, key.byteBuffer()), this.modificationMode).thenApply(lock -> null);
    }
}

