/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.WalStateProposeMessage;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class CacheGroupData
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final int grpId;
    private final String grpName;
    private final AffinityTopologyVersion startTopVer;
    private final UUID rcvdFrom;
    private final IgniteUuid deploymentId;
    private final CacheConfiguration<?, ?> cacheCfg;
    @GridToStringInclude
    private final Map<String, Integer> caches;
    private long flags;
    private final boolean persistenceEnabled;
    private final boolean walEnabled;
    private final List<WalStateProposeMessage> walChangeReqs;
    private final CacheConfigurationEnrichment cacheCfgEnrichment;

    CacheGroupData(CacheConfiguration cacheCfg, @Nullable String grpName, int grpId, UUID rcvdFrom, @Nullable AffinityTopologyVersion startTopVer, IgniteUuid deploymentId, Map<String, Integer> caches, long flags, boolean persistenceEnabled, boolean walEnabled, List<WalStateProposeMessage> walChangeReqs, CacheConfigurationEnrichment cacheCfgEnrichment) {
        assert (cacheCfg != null);
        assert (grpId != 0) : cacheCfg.getName();
        assert (deploymentId != null) : cacheCfg.getName();
        this.cacheCfg = cacheCfg;
        this.grpName = grpName;
        this.grpId = grpId;
        this.rcvdFrom = rcvdFrom;
        this.startTopVer = startTopVer;
        this.deploymentId = deploymentId;
        this.caches = caches;
        this.flags = flags;
        this.persistenceEnabled = persistenceEnabled;
        this.walEnabled = walEnabled;
        this.walChangeReqs = walChangeReqs;
        this.cacheCfgEnrichment = cacheCfgEnrichment;
    }

    @Nullable
    public AffinityTopologyVersion startTopologyVersion() {
        return this.startTopVer;
    }

    public UUID receivedFrom() {
        return this.rcvdFrom;
    }

    @Nullable
    public String groupName() {
        return this.grpName;
    }

    public int groupId() {
        return this.grpId;
    }

    public IgniteUuid deploymentId() {
        return this.deploymentId;
    }

    public CacheConfiguration<?, ?> config() {
        return this.cacheCfg;
    }

    Map<String, Integer> caches() {
        return this.caches;
    }

    public boolean persistenceEnabled() {
        return this.persistenceEnabled;
    }

    public boolean walEnabled() {
        return this.walEnabled;
    }

    public List<WalStateProposeMessage> walChangeRequests() {
        return this.walChangeReqs;
    }

    public CacheConfigurationEnrichment cacheConfigurationEnrichment() {
        return this.cacheCfgEnrichment;
    }

    public String toString() {
        return S.toString(CacheGroupData.class, this);
    }
}

