/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.table.AntiHijackAsyncCursor;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.lang.Cursor;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.DataStreamerTarget;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.CriteriaQueryOptions;
import org.apache.ignite.table.criteria.CriteriaQuerySource;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

abstract class PublicApiThreadingViewBase<T>
implements DataStreamerTarget<T>,
CriteriaQuerySource<T> {
    private final DataStreamerTarget<T> streamerTarget;
    private final CriteriaQuerySource<T> querySource;
    private final Executor asyncContinuationExecutor;

    PublicApiThreadingViewBase(DataStreamerTarget<T> streamerTarget, CriteriaQuerySource<T> querySource, Executor asyncContinuationExecutor) {
        this.streamerTarget = streamerTarget;
        this.querySource = querySource;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<T>> publisher, @Nullable DataStreamerOptions options) {
        return this.executeAsyncOp(() -> this.streamerTarget.streamData(publisher, options));
    }

    public <E, V, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R> receiver, Function<E, T> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        return this.executeAsyncOp(() -> this.streamerTarget.streamData(publisher, receiver, keyFunc, payloadFunc, receiverArg, resultSubscriber, options));
    }

    public Cursor<T> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return PublicApiThreadingViewBase.executeSyncOp(() -> this.querySource.query(tx, criteria, indexName, opts));
    }

    public CompletableFuture<AsyncCursor<T>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return this.executeAsyncOp(() -> this.querySource.queryAsync(tx, criteria, indexName, opts)).thenApply(cursor -> new AntiHijackAsyncCursor(cursor, this.asyncContinuationExecutor));
    }

    final <U> CompletableFuture<U> executeAsyncOp(Supplier<CompletableFuture<U>> operation) {
        CompletableFuture future = PublicApiThreading.execUserAsyncOperation(operation);
        return PublicApiThreading.preventThreadHijack((CompletableFuture)future, (Executor)this.asyncContinuationExecutor);
    }

    static <T> T executeSyncOp(Supplier<T> operation) {
        return (T)PublicApiThreading.execUserSyncOperation(operation);
    }

    static void executeSyncOp(Runnable operation) {
        PublicApiThreading.execUserSyncOperation((Runnable)operation);
    }
}

