/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io;

import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.IOExceptionBiFunction;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final int BUFFER_MAX = 8192;
    private static final String SCHEME_FILE = "file";
    private static final String SCHEME_JAR = "jar";
    private static final String SCHEME_ZIP = "zip";
    private static final String SCHEME_WSJAR = "wsjar";
    private static final String COLON = ":";

    @Blocking
    public static void eachFile(@NonNull URL url, String path, @NonNull Consumer<Path> consumer) {
        try {
            IOUtils.eachFile(url.toURI(), path, consumer);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    public static void eachFile(@NonNull URI uri, String path, @NonNull Consumer<Path> consumer) {
        block20: {
            ArrayList<Closeable> toClose = new ArrayList<Closeable>();
            try {
                Path myPath = IOUtils.resolvePath(uri, path, toClose, IOUtils::loadNestedJarUri);
                if (myPath == null) break block20;
                try (Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);){
                    Iterator it = walk.iterator();
                    while (it.hasNext()) {
                        Path currentPath = (Path)it.next();
                        if (currentPath.equals(myPath) || Files.isHidden(currentPath) || currentPath.getFileName().startsWith(".")) continue;
                        consumer.accept(currentPath);
                    }
                }
            }
            catch (IOException iOException) {
                for (Closeable closeable : toClose) {
                    try {
                        closeable.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                for (Closeable closeable : toClose) {
                    try {
                        closeable.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Nullable
    static Path resolvePath(@NonNull URI uri, String path, List<Closeable> toClose, IOExceptionBiFunction<List<Closeable>, String, Path> loadNestedJarUriFunction) throws IOException {
        String scheme = uri.getScheme();
        try {
            if (SCHEME_JAR.equals(scheme) || SCHEME_ZIP.equals(scheme) || SCHEME_WSJAR.equals(scheme)) {
                String jarUri = uri.getRawSchemeSpecificPart();
                int sep = jarUri.lastIndexOf("!/");
                if (sep != -1) {
                    jarUri = jarUri.substring(0, sep);
                }
                if (!jarUri.startsWith("file:")) {
                    jarUri = jarUri.startsWith("/") ? "file:" + jarUri : "file:/" + jarUri;
                }
                jarUri = jarUri + "!/";
                return loadNestedJarUriFunction.apply(toClose, jarUri).resolve(path);
            }
            if (SCHEME_FILE.equals(scheme)) {
                return Paths.get(uri).resolve(path);
            }
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            return null;
        }
    }

    private static Path loadNestedJarUri(List<Closeable> toClose, String jarUri) throws IOException {
        FileSystem zipfs;
        int sep = jarUri.lastIndexOf("!/");
        if (sep == -1) {
            return Paths.get(URI.create(jarUri));
        }
        Path jarPath = IOUtils.loadNestedJarUri(toClose, jarUri.substring(0, sep));
        if (Files.isDirectory(jarPath, new LinkOption[0])) {
            return jarPath;
        }
        try {
            zipfs = FileSystems.newFileSystem(jarPath, (ClassLoader)null);
            toClose.add(0, zipfs);
        }
        catch (ProviderNotFoundException e) {
            Path tmp = Files.createTempFile("micronaut-IOUtils-nested-zip", ".zip", new FileAttribute[0]);
            toClose.add(0, () -> Files.deleteIfExists(tmp));
            Files.copy(jarPath, tmp, StandardCopyOption.REPLACE_EXISTING);
            zipfs = FileSystems.newFileSystem(tmp, (ClassLoader)null);
            toClose.add(0, zipfs);
        }
        return zipfs.getPath(jarUri.substring(sep + 1), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    public static String readText(BufferedReader reader) throws IOException {
        StringBuilder answer = new StringBuilder();
        if (reader == null) {
            return answer.toString();
        }
        char[] charBuffer = new char[8192];
        try {
            int nbCharRead;
            while ((nbCharRead = reader.read(charBuffer)) != -1) {
                answer.append(charBuffer, 0, nbCharRead);
            }
            BufferedReader temp = reader;
            reader = null;
            ((Reader)temp).close();
        }
        finally {
            block11: {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    if (!IOLogging.LOG.isWarnEnabled()) break block11;
                    IOLogging.LOG.warn("Failed to close reader: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return answer.toString();
    }

    private static final class IOLogging {
        private static final Logger LOG = LoggerFactory.getLogger(IOLogging.class);

        private IOLogging() {
        }
    }
}

