/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.common.command;

import java.util.Objects;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.raft.client.WriteCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RangeCommand
implements WriteCommand {
    public static final int DEFAULT_BATCH_SIZE = 100;
    @NotNull
    private final byte[] keyFrom;
    @Nullable
    private final byte[] keyTo;
    @NotNull
    private final long revUpperBound;
    @NotNull
    private final String requesterNodeId;
    @NotNull
    private final IgniteUuid cursorId;
    private final boolean includeTombstones;
    private final int batchSize;

    public RangeCommand(@NotNull ByteArray keyFrom, @Nullable ByteArray keyTo, long revUpperBound, @NotNull String requesterNodeId, @NotNull IgniteUuid cursorId, boolean includeTombstones, int batchSize) {
        this.keyFrom = keyFrom.bytes();
        this.keyTo = keyTo == null ? null : keyTo.bytes();
        this.revUpperBound = revUpperBound;
        this.requesterNodeId = requesterNodeId;
        this.cursorId = cursorId;
        this.includeTombstones = includeTombstones;
        this.batchSize = batchSize;
    }

    @NotNull
    public byte[] keyFrom() {
        return this.keyFrom;
    }

    @Nullable
    public byte[] keyTo() {
        return this.keyTo;
    }

    @NotNull
    public long revUpperBound() {
        return this.revUpperBound;
    }

    @NotNull
    public String requesterNodeId() {
        return this.requesterNodeId;
    }

    @NotNull
    public IgniteUuid getCursorId() {
        return this.cursorId;
    }

    public boolean includeTombstones() {
        return this.includeTombstones;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public static RangeCommandBuilder builder(@NotNull ByteArray keyFrom, @NotNull String requesterNodeId, @NotNull IgniteUuid cursorId) {
        return new RangeCommandBuilder(keyFrom, requesterNodeId, cursorId);
    }

    public static class RangeCommandBuilder {
        private final ByteArray keyFrom;
        private ByteArray keyTo;
        private long revUpperBound = -1L;
        private final String requesterNodeId;
        private final IgniteUuid cursorId;
        private boolean includeTombstones = false;
        private int batchSize = 100;

        public RangeCommandBuilder(@NotNull ByteArray keyFrom, @NotNull String requesterNodeId, @NotNull IgniteUuid cursorId) {
            this.keyFrom = keyFrom;
            this.requesterNodeId = requesterNodeId;
            this.cursorId = cursorId;
        }

        public RangeCommandBuilder keyTo(ByteArray keyTo) {
            this.keyTo = keyTo;
            return this;
        }

        public RangeCommandBuilder revUpperBound(long revUpperBound) {
            this.revUpperBound = revUpperBound;
            return this;
        }

        public RangeCommandBuilder includeTombstones(boolean includeTombstones) {
            this.includeTombstones = includeTombstones;
            return this;
        }

        public RangeCommandBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public RangeCommand build() {
            return new RangeCommand(Objects.requireNonNull(this.keyFrom), this.keyTo, this.revUpperBound, Objects.requireNonNull(this.requesterNodeId), Objects.requireNonNull(this.cursorId), this.includeTombstones, this.batchSize);
        }
    }
}

