/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.schema.Columns;
import org.apache.ignite.internal.schema.marshaller.MarshallerUtil;
import org.apache.ignite.internal.schema.marshaller.asm.ColumnAccessCodeGenerator;
import org.apache.ignite.internal.schema.marshaller.asm.MarshallerCodeGenerator;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.lang.IgniteInternalException;

class ObjectMarshallerCodeGenerator
implements MarshallerCodeGenerator {
    private final Class<?> targetClass;
    private final Columns columns;
    private final ColumnAccessCodeGenerator[] columnAccessors;

    ObjectMarshallerCodeGenerator(Columns columns, Class<?> targetClass, int firstColIdx) {
        this.columns = columns;
        this.targetClass = targetClass;
        this.columnAccessors = new ColumnAccessCodeGenerator[columns.length()];
        Map flds = Arrays.stream(targetClass.getDeclaredFields()).collect(Collectors.toMap(f -> f.getName().toUpperCase(), Function.identity()));
        for (int i = 0; i < columns.length(); ++i) {
            Field field = (Field)flds.get(columns.column(i).name());
            if (field == null) {
                throw new IgniteInternalException("Field not found for column [col=" + columns.column(i) + "]");
            }
            this.columnAccessors[i] = ColumnAccessCodeGenerator.createAccessor(MarshallerUtil.mode(field.getType()), field.getName(), i + firstColIdx);
        }
    }

    @Override
    public BytecodeNode getValue(ParameterizedType marshallerClass, Variable obj, int i) {
        ColumnAccessCodeGenerator columnAccessor = this.columnAccessors[i];
        return BytecodeExpressions.getStatic((ParameterizedType)marshallerClass, (String)("FIELD_HANDLER_" + columnAccessor.columnIdx()), (ParameterizedType)ParameterizedType.type(VarHandle.class)).invoke("get", columnAccessor.mappedType(), new BytecodeExpression[]{obj});
    }

    public BytecodeBlock marshallObject(ParameterizedType marshallerClass, Variable asm, Variable obj) {
        BytecodeBlock block = new BytecodeBlock();
        for (int i = 0; i < this.columns.length(); ++i) {
            ColumnAccessCodeGenerator columnAccessor = this.columnAccessors[i];
            BytecodeExpression fld = BytecodeExpressions.getStatic((ParameterizedType)marshallerClass, (String)("FIELD_HANDLER_" + columnAccessor.columnIdx()), (ParameterizedType)ParameterizedType.type(VarHandle.class)).invoke("get", columnAccessor.mappedType(), new BytecodeExpression[]{obj});
            BytecodeExpression marshallNonNulExpr = asm.invoke(columnAccessor.writeMethodName(), RowAssembler.class, Collections.singletonList(columnAccessor.writeArgType()), new BytecodeExpression[]{fld.cast(columnAccessor.writeArgType())});
            if (this.columns.column(i).nullable()) {
                block.append((BytecodeNode)new BytecodeBlock().append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)fld)).ifTrue((BytecodeNode)asm.invoke("appendNull", RowAssembler.class, new BytecodeExpression[0])).ifFalse((BytecodeNode)marshallNonNulExpr)));
                continue;
            }
            block.append((BytecodeNode)marshallNonNulExpr);
        }
        return block;
    }

    public BytecodeBlock unmarshallObject(ParameterizedType marshallerClass, Variable row, Variable objVar, Variable objFactory) {
        BytecodeBlock block = new BytecodeBlock();
        block.append((BytecodeNode)objVar.set(objFactory.invoke("create", Object.class, new BytecodeExpression[0])));
        for (int i = 0; i < this.columns.length(); ++i) {
            ColumnAccessCodeGenerator columnAccessor = this.columnAccessors[i];
            BytecodeExpression val = row.invoke(columnAccessor.readMethodName(), columnAccessor.mappedType(), new BytecodeExpression[]{BytecodeExpressions.constantInt((int)columnAccessor.columnIdx())});
            block.append((BytecodeNode)BytecodeExpressions.getStatic((ParameterizedType)marshallerClass, (String)("FIELD_HANDLER_" + columnAccessor.columnIdx()), (ParameterizedType)ParameterizedType.type(VarHandle.class)).invoke("set", Void.TYPE, new BytecodeExpression[]{objVar, val}));
        }
        return block;
    }

    @Override
    public void initStaticHandlers(ClassDefinition classDef, FieldDefinition targetClassField) {
        MethodDefinition init = classDef.getClassInitializer();
        Variable lookup = init.getScope().createTempVariable(MethodHandles.Lookup.class);
        BytecodeBlock body = init.getBody().append((BytecodeNode)BytecodeExpressions.setStatic((FieldDefinition)targetClassField, (BytecodeExpression)BytecodeExpressions.invokeStatic(Class.class, (String)"forName", Class.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)this.targetClass.getName())})));
        body.append((BytecodeNode)lookup.set(BytecodeExpressions.invokeStatic(MethodHandles.class, (String)"privateLookupIn", MethodHandles.Lookup.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.getStatic((FieldDefinition)targetClassField), BytecodeExpressions.invokeStatic(MethodHandles.class, (String)"lookup", MethodHandles.Lookup.class, (BytecodeExpression[])new BytecodeExpression[0])})));
        for (int i = 0; i < this.columnAccessors.length; ++i) {
            FieldDefinition fld = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.STATIC, Access.FINAL), "FIELD_HANDLER_" + this.columnAccessors[i].columnIdx(), VarHandle.class);
            body.append((BytecodeNode)BytecodeExpressions.setStatic((FieldDefinition)fld, (BytecodeExpression)lookup.invoke("findVarHandle", VarHandle.class, new BytecodeExpression[]{BytecodeExpressions.getStatic((FieldDefinition)targetClassField), BytecodeExpressions.constantString((String)this.columnAccessors[i].fieldName()), BytecodeExpressions.constantClass(this.columnAccessors[i].mappedType())})));
        }
    }
}

