/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.SocketChannel;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.configuration.schemas.network.NetworkView;
import org.apache.ignite.internal.network.handshake.HandshakeManager;
import org.apache.ignite.internal.network.netty.InNetworkObject;
import org.apache.ignite.internal.network.netty.NettySender;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.internal.network.netty.PipelineUtils;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.internal.network.serialization.SerializationService;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.NettyBootstrapFactory;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NettyServer {
    private final Object startStopLock = new Object();
    private final NettyBootstrapFactory bootstrapFactory;
    private final NetworkView configuration;
    private final SerializationService serializationService;
    private final Consumer<InNetworkObject> messageListener;
    private final Supplier<HandshakeManager> handshakeManager;
    private CompletableFuture<Void> serverStartFuture;
    @Nullable
    private volatile ServerChannel channel;
    @Nullable
    private CompletableFuture<Void> serverCloseFuture;
    private final Consumer<NettySender> newConnectionListener;
    private boolean stopped;

    public NettyServer(NetworkView configuration, Supplier<HandshakeManager> handshakeManager, Consumer<NettySender> newConnectionListener, Consumer<InNetworkObject> messageListener, SerializationService serializationService, NettyBootstrapFactory bootstrapFactory) {
        this.configuration = configuration;
        this.handshakeManager = handshakeManager;
        this.newConnectionListener = newConnectionListener;
        this.messageListener = messageListener;
        this.serializationService = serializationService;
        this.bootstrapFactory = bootstrapFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> start() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.stopped) {
                throw new IgniteInternalException("Attempted to start an already stopped server");
            }
            if (this.serverStartFuture != null) {
                throw new IgniteInternalException("Attempted to start an already started server");
            }
            ServerBootstrap bootstrap = this.bootstrapFactory.createServerBootstrap();
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    PerSessionSerializationService sessionSerializationService = new PerSessionSerializationService(NettyServer.this.serializationService);
                    HandshakeManager manager = NettyServer.this.handshakeManager.get();
                    PipelineUtils.setup(ch.pipeline(), sessionSerializationService, manager, NettyServer.this.messageListener);
                    manager.handshakeFuture().thenAccept((Consumer)NettyServer.this.newConnectionListener);
                }
            });
            int port = this.configuration.port();
            int portRange = this.configuration.portRange();
            CompletableFuture<Channel> bindFuture = new CompletableFuture<Channel>();
            this.tryBind(bootstrap, port, port + portRange, port, bindFuture);
            this.serverStartFuture = ((CompletableFuture)bindFuture.handle((channel, err) -> {
                Object object = this.startStopLock;
                synchronized (object) {
                    if (channel != null) {
                        this.serverCloseFuture = NettyUtils.toCompletableFuture(channel.closeFuture());
                    }
                    this.channel = (ServerChannel)channel;
                    if (err != null || this.stopped) {
                        Throwable stopErr = err != null ? err : new CancellationException("Server was stopped");
                        return CompletableFuture.failedFuture(stopErr);
                    }
                    return CompletableFuture.completedFuture(null);
                }
            })).thenCompose(Function.identity());
            return this.serverStartFuture;
        }
    }

    private void tryBind(ServerBootstrap bootstrap, int port, int endPort, int startPort, CompletableFuture<Channel> fut) {
        if (port > endPort) {
            fut.completeExceptionally(new IllegalStateException("No available port in range [" + startPort + "-" + endPort + "]"));
        }
        bootstrap.bind(port).addListener(future -> {
            if (future.isSuccess()) {
                fut.complete(future.channel());
            } else if (future.isCancelled()) {
                fut.cancel(true);
            } else {
                this.tryBind(bootstrap, port + 1, endPort, startPort, fut);
            }
        });
    }

    public SocketAddress address() {
        return this.channel.localAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.stopped) {
                return CompletableFuture.completedFuture(null);
            }
            this.stopped = true;
            if (this.serverStartFuture == null) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture<Void> serverCloseFuture0 = this.serverCloseFuture;
            return ((CompletableFuture)this.serverStartFuture.handle((unused, throwable) -> {
                if (this.channel != null) {
                    this.channel.close();
                }
                return serverCloseFuture0 == null ? CompletableFuture.completedFuture(null) : serverCloseFuture0;
            })).thenCompose(Function.identity());
        }
    }

    @TestOnly
    public boolean isRunning() {
        ServerChannel channel0 = this.channel;
        return channel0 != null && channel0.isOpen();
    }
}

