/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.command;

import java.util.UUID;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.ByteBufferRow;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.table.distributed.command.CommandUtils;
import org.apache.ignite.internal.table.distributed.command.PartitionCommand;
import org.apache.ignite.internal.table.distributed.replicator.TablePartitionId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateCommand
extends PartitionCommand {
    private final TablePartitionId commitReplicationGroupId;
    private final RowId rowId;
    private transient BinaryRow row;
    private byte[] rowBytes;

    public UpdateCommand(@NotNull TablePartitionId commitReplicationGroupId, @NotNull RowId rowId, @Nullable BinaryRow row, @NotNull UUID txId) {
        super(txId);
        this.commitReplicationGroupId = commitReplicationGroupId;
        this.rowId = rowId;
        this.row = row;
        this.rowBytes = CommandUtils.rowToBytes(row);
    }

    public UpdateCommand(@NotNull TablePartitionId commitReplicationGroupId, @NotNull RowId rowId, @NotNull UUID txId) {
        this(commitReplicationGroupId, rowId, null, txId);
    }

    public TablePartitionId getCommitReplicationGroupId() {
        return this.commitReplicationGroupId;
    }

    public RowId getRowId() {
        return this.rowId;
    }

    public BinaryRow getRow() {
        if (this.row == null && this.rowBytes != null) {
            this.row = new ByteBufferRow(this.rowBytes);
        }
        return this.row;
    }
}

