/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMessage;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequestFactory;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.cookie.Cookies;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public interface HttpRequest<B>
extends HttpMessage<B> {
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";

    @NonNull
    public Cookies getCookies();

    @NonNull
    public HttpParameters getParameters();

    @NonNull
    public HttpMethod getMethod();

    @NonNull
    public URI getUri();

    default public MutableHttpRequest<B> mutate() {
        throw new UnsupportedOperationException("Request is immutable");
    }

    default public HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_1_1;
    }

    default public Collection<MediaType> accept() {
        HttpHeaders headers = this.getHeaders();
        if (headers.contains("Accept")) {
            return MediaType.orderedOf(headers.getAll("Accept"));
        }
        return Collections.emptySet();
    }

    @NonNull
    default public String getMethodName() {
        return this.getMethod().name();
    }

    @NonNull
    default public Optional<Principal> getUserPrincipal() {
        return this.getAttribute(HttpAttributes.PRINCIPAL, Principal.class);
    }

    @NonNull
    default public <T extends Principal> Optional<T> getUserPrincipal(Class<T> principalType) {
        return this.getAttribute(HttpAttributes.PRINCIPAL, principalType);
    }

    @NonNull
    default public String getPath() {
        return this.getUri().getRawPath();
    }

    @NonNull
    default public InetSocketAddress getRemoteAddress() {
        return this.getServerAddress();
    }

    @NonNull
    default public InetSocketAddress getServerAddress() {
        String host = this.getUri().getHost();
        int port = this.getUri().getPort();
        return new InetSocketAddress(host != null ? host : "localhost", port > -1 ? port : 80);
    }

    @Nullable
    default public String getServerName() {
        return this.getUri().getHost();
    }

    default public boolean isSecure() {
        String scheme = this.getUri().getScheme();
        return scheme != null && scheme.equals(SCHEME_HTTPS);
    }

    @Override
    default public HttpRequest<B> setAttribute(CharSequence name, Object value) {
        return (HttpRequest)HttpMessage.super.setAttribute(name, value);
    }

    @Override
    default public Optional<Locale> getLocale() {
        return this.getHeaders().findFirst("Accept-Language").map(text -> {
            int len = text.length();
            if (len == 0 || len == 1 && text.charAt(0) == '*') {
                return Locale.getDefault().toLanguageTag();
            }
            if (text.indexOf(59) > -1) {
                text = text.split(";")[0];
            }
            if (text.indexOf(44) > -1) {
                text = text.split(",")[0];
            }
            return text;
        }).map(Locale::forLanguageTag);
    }

    default public Optional<Certificate> getCertificate() {
        return this.getAttribute(HttpAttributes.X509_CERTIFICATE, Certificate.class);
    }

    public static <T> MutableHttpRequest<T> GET(URI uri) {
        return HttpRequest.GET(uri.toString());
    }

    public static <T> MutableHttpRequest<T> GET(String uri) {
        return HttpRequestFactory.INSTANCE.get(uri);
    }

    public static <T> MutableHttpRequest<T> OPTIONS(URI uri) {
        return HttpRequest.OPTIONS(uri.toString());
    }

    public static <T> MutableHttpRequest<T> OPTIONS(String uri) {
        return HttpRequestFactory.INSTANCE.options(uri);
    }

    public static MutableHttpRequest<?> HEAD(URI uri) {
        return HttpRequest.HEAD(uri.toString());
    }

    public static MutableHttpRequest<?> HEAD(String uri) {
        return HttpRequestFactory.INSTANCE.head(uri);
    }

    public static <T> MutableHttpRequest<T> POST(URI uri, T body) {
        return HttpRequest.POST(uri.toString(), body);
    }

    public static <T> MutableHttpRequest<T> POST(String uri, T body) {
        Objects.requireNonNull(uri, "Argument [uri] is required");
        return HttpRequestFactory.INSTANCE.post(uri, body);
    }

    public static <T> MutableHttpRequest<T> PUT(URI uri, T body) {
        return HttpRequest.PUT(uri.toString(), body);
    }

    public static <T> MutableHttpRequest<T> PUT(String uri, T body) {
        Objects.requireNonNull(uri, "Argument [uri] is required");
        return HttpRequestFactory.INSTANCE.put(uri, body);
    }

    public static <T> MutableHttpRequest<T> PATCH(URI uri, T body) {
        return HttpRequest.PATCH(uri.toString(), body);
    }

    public static <T> MutableHttpRequest<T> PATCH(String uri, T body) {
        Objects.requireNonNull(uri, "Argument [uri] is required");
        return HttpRequestFactory.INSTANCE.patch(uri, body);
    }

    public static <T> MutableHttpRequest<T> DELETE(URI uri, T body) {
        return HttpRequest.DELETE(uri.toString(), body);
    }

    public static <T> MutableHttpRequest<T> DELETE(String uri, T body) {
        Objects.requireNonNull(uri, "Argument [uri] is required");
        return HttpRequestFactory.INSTANCE.delete(uri, body);
    }

    public static <T> MutableHttpRequest<T> DELETE(String uri) {
        return HttpRequest.DELETE(uri, null);
    }

    public static <T> MutableHttpRequest<T> create(HttpMethod httpMethod, String uri) {
        Objects.requireNonNull(httpMethod, "Argument [httpMethod] is required");
        return HttpRequest.create(httpMethod, uri, httpMethod.name());
    }

    public static <T> MutableHttpRequest<T> create(HttpMethod httpMethod, String uri, String httpMethodName) {
        Objects.requireNonNull(httpMethod, "Argument [httpMethod] is required");
        Objects.requireNonNull(uri, "Argument [uri] is required");
        Objects.requireNonNull(httpMethodName, "Argument [httpMethodName] is required");
        return HttpRequestFactory.INSTANCE.create(httpMethod, uri, httpMethodName);
    }
}

