/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.Tuple;

public class ClientBinaryTupleUtils {
    public static void readAndSetColumnValue(BinaryTupleReader reader, int readerIndex, Tuple tuple, String columnName, int clientDataType, int decimalScale) {
        if (reader.hasNullValue(readerIndex)) {
            tuple.set(columnName, null);
            return;
        }
        switch (clientDataType) {
            case 1: {
                tuple.set(columnName, (Object)reader.byteValue(readerIndex));
                break;
            }
            case 2: {
                tuple.set(columnName, (Object)reader.shortValue(readerIndex));
                break;
            }
            case 3: {
                tuple.set(columnName, (Object)reader.intValue(readerIndex));
                break;
            }
            case 4: {
                tuple.set(columnName, (Object)reader.longValue(readerIndex));
                break;
            }
            case 5: {
                tuple.set(columnName, (Object)Float.valueOf(reader.floatValue(readerIndex)));
                break;
            }
            case 6: {
                tuple.set(columnName, (Object)reader.doubleValue(readerIndex));
                break;
            }
            case 7: {
                tuple.set(columnName, (Object)reader.decimalValue(readerIndex, decimalScale));
                break;
            }
            case 8: {
                tuple.set(columnName, (Object)reader.uuidValue(readerIndex));
                break;
            }
            case 9: {
                tuple.set(columnName, (Object)reader.stringValue(readerIndex));
                break;
            }
            case 10: {
                tuple.set(columnName, (Object)reader.bytesValue(readerIndex));
                break;
            }
            case 11: {
                tuple.set(columnName, (Object)reader.bitmaskValue(readerIndex));
                break;
            }
            case 16: {
                tuple.set(columnName, (Object)reader.numberValue(readerIndex));
                break;
            }
            case 12: {
                tuple.set(columnName, (Object)reader.dateValue(readerIndex));
                break;
            }
            case 13: {
                tuple.set(columnName, (Object)reader.timeValue(readerIndex));
                break;
            }
            case 14: {
                tuple.set(columnName, (Object)reader.dateTimeValue(readerIndex));
                break;
            }
            case 15: {
                tuple.set(columnName, (Object)reader.timestampValue(readerIndex));
                break;
            }
            default: {
                throw ClientBinaryTupleUtils.unsupportedTypeException(clientDataType);
            }
        }
    }

    public static Object readObject(BinaryTupleReader reader, int index) {
        if (reader.hasNullValue(index)) {
            return null;
        }
        int type = reader.intValue(index);
        int valIdx = index + 2;
        switch (type) {
            case 1: {
                return reader.byteValue(valIdx);
            }
            case 2: {
                return reader.shortValue(valIdx);
            }
            case 3: {
                return reader.intValue(valIdx);
            }
            case 4: {
                return reader.longValue(valIdx);
            }
            case 5: {
                return Float.valueOf(reader.floatValue(valIdx));
            }
            case 6: {
                return reader.doubleValue(valIdx);
            }
            case 7: {
                return reader.decimalValue(valIdx, reader.intValue(index + 1));
            }
            case 8: {
                return reader.uuidValue(valIdx);
            }
            case 9: {
                return reader.stringValue(valIdx);
            }
            case 10: {
                return reader.bytesValue(valIdx);
            }
            case 11: {
                return reader.bitmaskValue(valIdx);
            }
            case 12: {
                return reader.dateValue(valIdx);
            }
            case 13: {
                return reader.timeValue(valIdx);
            }
            case 14: {
                return reader.dateTimeValue(valIdx);
            }
            case 15: {
                return reader.timestampValue(valIdx);
            }
            case 16: {
                return reader.numberValue(valIdx);
            }
            case 17: {
                return reader.byteValue(valIdx) != 0;
            }
            case 18: {
                return reader.durationValue(valIdx);
            }
            case 19: {
                return reader.periodValue(valIdx);
            }
        }
        throw ClientBinaryTupleUtils.unsupportedTypeException(type);
    }

    public static void appendObject(BinaryTupleBuilder builder, Object obj) {
        if (obj == null) {
            builder.appendNull();
            builder.appendNull();
            builder.appendNull();
        } else if (obj instanceof Byte) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 1);
            builder.appendByte((Byte)obj);
        } else if (obj instanceof Short) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 2);
            builder.appendShort((Short)obj);
        } else if (obj instanceof Integer) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 3);
            builder.appendInt((Integer)obj);
        } else if (obj instanceof Long) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 4);
            builder.appendLong((Long)obj);
        } else if (obj instanceof Float) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 5);
            builder.appendFloat((Float)obj);
        } else if (obj instanceof Double) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 6);
            builder.appendDouble((Double)obj);
        } else if (obj instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)obj;
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 7, bigDecimal.scale());
            builder.appendDecimal(bigDecimal, bigDecimal.scale());
        } else if (obj instanceof UUID) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 8);
            builder.appendUuid((UUID)obj);
        } else if (obj instanceof String) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 9);
            builder.appendString((String)obj);
        } else if (obj instanceof byte[]) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 10);
            builder.appendBytes((byte[])obj);
        } else if (obj instanceof BitSet) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 11);
            builder.appendBitmask((BitSet)obj);
        } else if (obj instanceof LocalDate) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 12);
            builder.appendDate((LocalDate)obj);
        } else if (obj instanceof LocalTime) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 13);
            builder.appendTime((LocalTime)obj);
        } else if (obj instanceof LocalDateTime) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 14);
            builder.appendDateTime((LocalDateTime)obj);
        } else if (obj instanceof Instant) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 15);
            builder.appendTimestamp((Instant)obj);
        } else if (obj instanceof BigInteger) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 16);
            builder.appendNumber((BigInteger)obj);
        } else if (obj instanceof Boolean) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 17);
            builder.appendByte((byte)((Boolean)obj != false ? 1 : 0));
        } else if (obj instanceof Duration) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 18);
            builder.appendDuration((Duration)obj);
        } else if (obj instanceof Period) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, 19);
            builder.appendPeriod((Period)obj);
        } else {
            throw ClientBinaryTupleUtils.unsupportedTypeException(obj.getClass());
        }
    }

    private static void appendTypeAndScale(BinaryTupleBuilder builder, int type, int scale) {
        builder.appendInt(type);
        builder.appendInt(scale);
    }

    private static void appendTypeAndScale(BinaryTupleBuilder builder, int type) {
        builder.appendInt(type);
        builder.appendInt(0);
    }

    private static IgniteException unsupportedTypeException(int dataType) {
        return new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unsupported type: " + dataType);
    }

    private static IgniteException unsupportedTypeException(Class<?> cls) {
        return new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unsupported type: " + cls);
    }
}

