/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.sql.engine.rel.AbstractIndexScan;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteLogicalIndexScan
extends AbstractIndexScan {
    public static IgniteLogicalIndexScan create(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, String idxName, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        List<SearchBounds> searchBounds;
        InternalIgniteTable tbl = (InternalIgniteTable)table.unwrap(InternalIgniteTable.class);
        IgniteTypeFactory typeFactory = Commons.typeFactory(cluster);
        IgniteIndex index = tbl.getIndex(idxName);
        RelCollation collation = TraitUtils.createCollation(index.columns(), index.collations(), tbl.descriptor());
        if (requiredColumns != null) {
            Mappings.TargetMapping targetMapping = Commons.mapping(requiredColumns, tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount());
            collation = (RelCollation)collation.apply(targetMapping);
        }
        if (index.type() == IgniteIndex.Type.HASH) {
            searchBounds = IgniteLogicalIndexScan.buildHashIndexConditions(cluster, tbl, index.columns(), cond, requiredColumns);
        } else if (index.type() == IgniteIndex.Type.SORTED) {
            searchBounds = IgniteLogicalIndexScan.buildSortedIndexConditions(cluster, tbl, collation, cond, requiredColumns);
        } else {
            throw new AssertionError((Object)("Unknown index type [type=" + index.type() + "]"));
        }
        return new IgniteLogicalIndexScan(cluster, traits, table, idxName, index.type(), proj, cond, searchBounds, requiredColumns);
    }

    private IgniteLogicalIndexScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable tbl, String idxName, IgniteIndex.Type type, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable List<SearchBounds> searchBounds, @Nullable ImmutableBitSet requiredCols) {
        super(cluster, traits, List.of(), tbl, idxName, type, proj, cond, searchBounds, requiredCols);
    }

    private static List<SearchBounds> buildSortedIndexConditions(RelOptCluster cluster, InternalIgniteTable table, RelCollation collation, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        if (collation.getFieldCollations().isEmpty()) {
            return List.of();
        }
        return RexUtils.buildSortedIndexConditions(cluster, collation, cond, table.getRowType((RelDataTypeFactory)Commons.typeFactory(cluster)), requiredColumns);
    }

    private static List<SearchBounds> buildHashIndexConditions(RelOptCluster cluster, InternalIgniteTable table, List<String> indexedColumns, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        return RexUtils.buildHashIndexConditions(cluster, indexedColumns, cond, table.getRowType((RelDataTypeFactory)Commons.typeFactory(cluster)), requiredColumns);
    }
}

