/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaParameterizedType;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;
import com.thoughtworks.qdox.type.TypeResolver;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultJavaParameterizedType
extends DefaultJavaType
implements JavaParameterizedType {
    private List<JavaType> actualArgumentTypes = Collections.emptyList();

    public DefaultJavaParameterizedType(String fullName, String name, int dimensions, TypeResolver typeResolver) {
        super(fullName, name, dimensions, typeResolver);
    }

    @Override
    public List<JavaType> getActualTypeArguments() {
        return this.actualArgumentTypes;
    }

    public void setActualArgumentTypes(List<JavaType> actualArgumentTypes) {
        this.actualArgumentTypes = actualArgumentTypes;
    }

    @Override
    public String getGenericValue() {
        StringBuilder result = new StringBuilder(this.name);
        if (!this.actualArgumentTypes.isEmpty()) {
            result.append("<");
            Iterator<JavaType> iter = this.actualArgumentTypes.iterator();
            while (iter.hasNext()) {
                result.append(iter.next().getGenericValue());
                if (!iter.hasNext()) continue;
                result.append(",");
            }
            result.append(">");
        }
        for (int i = 0; i < this.getDimensions(); ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public String getGenericCanonicalName() {
        String base = this.isArray() ? this.getComponentType().getCanonicalName() : this.getCanonicalName();
        StringBuilder result = new StringBuilder(base);
        if (!this.actualArgumentTypes.isEmpty()) {
            result.append("<");
            Iterator<JavaType> iter = this.actualArgumentTypes.iterator();
            while (iter.hasNext()) {
                result.append(iter.next().getGenericCanonicalName());
                if (!iter.hasNext()) continue;
                result.append(",");
            }
            result.append(">");
        }
        for (int i = 0; i < this.getDimensions(); ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public String getGenericFullyQualifiedName() {
        StringBuilder result = new StringBuilder(this.isResolved() ? this.fullName : this.name);
        if (!this.actualArgumentTypes.isEmpty()) {
            result.append("<");
            Iterator<JavaType> iter = this.actualArgumentTypes.iterator();
            while (iter.hasNext()) {
                result.append(iter.next().getGenericFullyQualifiedName());
                if (!iter.hasNext()) continue;
                result.append(",");
            }
            result.append(">");
        }
        for (int i = 0; i < this.getDimensions(); ++i) {
            result.append("[]");
        }
        return result.toString();
    }
}

