/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.vault.config.PropertySourceLocatorConfiguration;
import org.springframework.cloud.vault.config.PropertySourceLocatorConfigurationFactory;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadataFactory;
import org.springframework.cloud.vault.config.VaultConfigLocation;
import org.springframework.cloud.vault.config.VaultConfigurer;
import org.springframework.cloud.vault.config.VaultKeyValueBackendProperties;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptor;
import org.springframework.cloud.vault.config.VaultSecretBackendDescriptorFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.core.util.PropertyTransformer;
import org.springframework.vault.core.util.PropertyTransformers;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class VaultConfigDataLocationResolver
implements ConfigDataLocationResolver<VaultConfigLocation> {
    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        return location.getValue().startsWith("vault:");
    }

    public List<VaultConfigLocation> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        return Collections.emptyList();
    }

    public List<VaultConfigLocation> resolveProfileSpecific(ConfigDataLocationResolverContext context, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        if (!location.getValue().startsWith("vault:")) {
            return Collections.emptyList();
        }
        VaultConfigDataLocationResolver.registerVaultProperties(context);
        if (location.getValue().equals("vault:") || location.getValue().equals("vault://")) {
            List<SecretBackendMetadata> sorted = this.getSecretBackends(context, profiles);
            return sorted.stream().map(it -> new VaultConfigLocation((SecretBackendMetadata)it, location.isOptional())).collect(Collectors.toList());
        }
        String contextPath = location.getValue().substring("vault:".length());
        while (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return Collections.singletonList(new VaultConfigLocation(contextPath, VaultConfigDataLocationResolver.getPropertyTransformer(contextPath), location.isOptional()));
    }

    private static PropertyTransformer getPropertyTransformer(String contextPath) {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)contextPath).build();
        String prefix = (String)uriComponents.getQueryParams().getFirst((Object)"prefix");
        if (StringUtils.hasText((String)prefix) && StringUtils.hasText((String)uriComponents.getPath())) {
            return PropertyTransformers.propertyNamePrefix((String)prefix);
        }
        return PropertyTransformers.noop();
    }

    private static void registerVaultProperties(ConfigDataLocationResolverContext context) {
        context.getBootstrapContext().registerIfAbsent(VaultProperties.class, ignore -> {
            VaultProperties vaultProperties = (VaultProperties)context.getBinder().bindOrCreate("spring.cloud.vault", VaultProperties.class);
            vaultProperties.setApplicationName((String)context.getBinder().bind("spring.application.name", String.class).orElse((Object)vaultProperties.getApplicationName()));
            return vaultProperties;
        });
    }

    private List<SecretBackendMetadata> getSecretBackends(ConfigDataLocationResolverContext context, Profiles profiles) {
        List<VaultSecretBackendDescriptor> descriptors = VaultConfigDataLocationResolver.findDescriptors(context.getBinder());
        List<SecretBackendMetadataFactory<? super VaultSecretBackendDescriptor>> factories = VaultConfigDataLocationResolver.getSecretBackendMetadataFactories();
        Collection<VaultConfigurer> vaultConfigurers = VaultConfigDataLocationResolver.getVaultConfigurers(context.getBootstrapContext());
        PropertySourceLocatorConfigurationFactory factory = new PropertySourceLocatorConfigurationFactory(vaultConfigurers, descriptors, factories);
        VaultKeyValueBackendProperties kvProperties = VaultConfigDataLocationResolver.getKeyValueProperties(context, profiles);
        PropertySourceLocatorConfiguration configuration = factory.getPropertySourceConfiguration(kvProperties);
        Collection<SecretBackendMetadata> secretBackends = configuration.getSecretBackends();
        ArrayList<SecretBackendMetadata> sorted = new ArrayList<SecretBackendMetadata>(secretBackends);
        AnnotationAwareOrderComparator.sort(sorted);
        Collections.reverse(sorted);
        return sorted;
    }

    private static Collection<VaultConfigurer> getVaultConfigurers(ConfigurableBootstrapContext bootstrapContext) {
        ArrayList<VaultConfigurer> vaultConfigurers = new ArrayList<VaultConfigurer>(1);
        if (bootstrapContext.isRegistered(VaultConfigurer.class)) {
            vaultConfigurers.add((VaultConfigurer)bootstrapContext.get(VaultConfigurer.class));
        }
        return vaultConfigurers;
    }

    private static VaultKeyValueBackendProperties getKeyValueProperties(ConfigDataLocationResolverContext context, Profiles profiles) {
        VaultKeyValueBackendProperties kvProperties = (VaultKeyValueBackendProperties)context.getBinder().bindOrCreate("spring.cloud.vault.kv", VaultKeyValueBackendProperties.class);
        Binder binder = context.getBinder();
        kvProperties.setApplicationName((String)binder.bind("spring.cloud.vault.kv.application-name", String.class).orElseGet(() -> (String)binder.bind("spring.cloud.vault.application-name", String.class).orElseGet(() -> (String)binder.bind("spring.application.name", String.class).orElse((Object)""))));
        kvProperties.setProfiles((List)binder.bind("spring.cloud.vault.kv.profiles", Bindable.listOf(String.class)).orElseGet(() -> ((Profiles)profiles).getActive()));
        return kvProperties;
    }

    private static List<VaultSecretBackendDescriptor> findDescriptors(Binder binder) {
        ArrayList descriptorsOrFactories = new ArrayList();
        descriptorsOrFactories.addAll(SpringFactoriesLoader.loadFactories(VaultSecretBackendDescriptor.class, (ClassLoader)VaultConfigDataLocationResolver.class.getClassLoader()));
        descriptorsOrFactories.addAll(SpringFactoriesLoader.loadFactories(VaultSecretBackendDescriptorFactory.class, (ClassLoader)VaultConfigDataLocationResolver.class.getClassLoader()));
        ArrayList<VaultSecretBackendDescriptor> descriptors = new ArrayList<VaultSecretBackendDescriptor>(descriptorsOrFactories.size());
        for (Object descriptorOrFactory : descriptorsOrFactories) {
            Class<?> descriptorClass = descriptorOrFactory.getClass();
            MergedAnnotations annotations = MergedAnnotations.from(descriptorClass);
            if (annotations.isPresent(ConfigurationProperties.class)) {
                String prefix = annotations.get(ConfigurationProperties.class).getString("prefix");
                Object hydratedDescriptor = binder.bindOrCreate(prefix, descriptorClass);
                if (hydratedDescriptor instanceof VaultSecretBackendDescriptorFactory) {
                    descriptors.addAll(((VaultSecretBackendDescriptorFactory)hydratedDescriptor).create());
                    continue;
                }
                if (hydratedDescriptor instanceof VaultSecretBackendDescriptor) {
                    descriptors.add((VaultSecretBackendDescriptor)hydratedDescriptor);
                    continue;
                }
                throw new IllegalStateException(String.format("Descriptor %s is neither implements VaultSecretBackendDescriptorFactory nor VaultSecretBackendDescriptor", ClassUtils.getQualifiedName(descriptorOrFactory.getClass())));
            }
            throw new IllegalStateException(String.format("VaultSecretBackendDescriptor %s is not annotated with @ConfigurationProperties", ClassUtils.getQualifiedName(descriptorOrFactory.getClass())));
        }
        return descriptors;
    }

    private static List<SecretBackendMetadataFactory<? super VaultSecretBackendDescriptor>> getSecretBackendMetadataFactories() {
        return SpringFactoriesLoader.loadFactories(SecretBackendMetadataFactory.class, (ClassLoader)VaultConfigDataLocationResolver.class.getClassLoader());
    }
}

